package com.liferay.portal.service;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.persistence.GroupUtil;

public class CustomGroupLocalService extends GroupLocalServiceWrapper {

	public CustomGroupLocalService(GroupLocalService groupLocalService) {
		super(groupLocalService);
	}

	@Override
	public boolean hasStagingGroup(long liveGroupId) throws SystemException {
		Group liveGroup = GroupUtil.fetchByPrimaryKey(liveGroupId);

		if (liveGroup.isUser() || liveGroup.isLayoutSetPrototype()) {
			return false;
		}

		return super.hasStagingGroup(liveGroupId);
	}

}